/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JTextField;

public class DoubleField
extends JTextField {
    private static final int MINIMUM_WIDTH = 60;
    private static final int MINIMUM_HEIGHT = 22;
    private boolean exceptionOnError;
    private double minValue;
    private double maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private IODialog dialog;

    public DoubleField() {
        this("", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double d) {
        this(String.valueOf(d), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double d, double d2) {
        this("", d, d2);
    }

    public DoubleField(double d, double d2, double d3) {
        this(String.valueOf(d), d2, d3);
    }

    private DoubleField(String string, double d, double d2) {
        this.setBackground(Color.white);
        this.setHorizontalAlignment(4);
        this.minValue = d;
        this.maxValue = d2;
        this.setText(string);
        this.exceptionOnError = false;
    }

    public double getValue() {
        double d;
        block7: {
            String string = this.getText();
            String string2 = null;
            d = 0.0;
            try {
                d = Double.valueOf(string.trim());
                if (d >= this.minValue && d <= this.maxValue) break block7;
                string2 = "Value is outside the specified range";
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "Illegal numeric format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(string2);
            }
            String string3 = "Enter a number";
            if (this.minValue != Double.NEGATIVE_INFINITY) {
                string3 = this.maxValue != Double.POSITIVE_INFINITY ? String.valueOf(string3) + " between " + this.minValue + " and " + this.maxValue : String.valueOf(string3) + " greater than " + this.minValue;
            } else if (this.maxValue != Double.POSITIVE_INFINITY) {
                string3 = String.valueOf(string3) + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            d = this.dialog.readDouble(string3, this.minValue, this.maxValue);
        }
        this.setValue(d);
        return d;
    }

    public void setValue(double d) {
        String string = String.valueOf(d);
        if (this.formatter != null) {
            string = this.formatter.format(d);
        }
        this.setText(string);
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String string) {
        this.formatString = string;
        this.formatter = string == null ? null : new DecimalFormat(string);
        try {
            this.setValue(Double.valueOf(this.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setExceptionOnError(boolean bl) {
        this.exceptionOnError = bl;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(60, dimension.width), Math.max(22, dimension.height));
    }
}

